// scriptView.cpp : implementation of the CScriptView class
//

#include "stdafx.h"
#include "script.h"
#include "FunctionListDialog.h"
#include "FindDialog.h"
#include "GotoLineDialog.h"
#include "utility.h"
#ifdef WIN32_PLATFORM_PSPC
#include "aygshell.h"
#endif

#include "scriptDoc.h"
#include "scriptView.h"

#undef _DEBUG // EMP DIKEO

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern HWND ghwndMain;
extern LaunchModeType gLaunchMode;
extern bool gbFileHasValidChecksum;

extern bool gbShowEditorWindow;	//Is the main window shown?
extern bool gbAllowEmptyLaunch;	//Can the app be launched without a file?
extern bool gbCloseOnEnd;		//Does entire app close when program exits?
extern bool gbAllowSave;		//Can apps be saved?
extern bool gbCanOpenPlainFiles; //Can we open non-checksummed files?
extern bool gbProtectedFile;	//Is the file protected (not editable?)

extern unsigned long giSerialNumber;
extern DWORD gdwPrefFlags;

 
/////////////////////////////////////////////////////////////////////////////
// CScriptView

IMPLEMENT_DYNCREATE(CScriptView, CEditView)

BEGIN_MESSAGE_MAP(CScriptView, CEditView)
	//{{AFX_MSG_MAP(CScriptView)
	ON_WM_CHAR()
	ON_WM_KEYDOWN()
	ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
	ON_COMMAND(ID_EDIT_CUT, OnEditCut)
	ON_COMMAND(ID_EDIT_PASTE, OnEditPaste)
	ON_COMMAND(ID_EDIT_UNDO, OnEditUndo)
	ON_WM_CREATE()
	ON_UPDATE_COMMAND_UI(ID_EDIT_FIND, OnUpdateEditFind)
	ON_COMMAND(ID_EDIT_FIND, OnEditFind)
	ON_UPDATE_COMMAND_UI(ID_EDIT_FINDALL, OnUpdateEditFindall)
	ON_COMMAND(ID_EDIT_FINDALL, OnEditFindall)
	ON_COMMAND(ID_EDIT_FINDNEXT, OnEditFindnext)
	ON_UPDATE_COMMAND_UI(ID_EDIT_FINDNEXT, OnUpdateEditFindnext)
	ON_COMMAND(ID_EDIT_FORMAT, OnEditFormat)
	ON_UPDATE_COMMAND_UI(ID_EDIT_FORMAT, OnUpdateEditFormat)
	ON_COMMAND(ID_EDIT_GOTO, OnEditGoto)
	ON_UPDATE_COMMAND_UI(ID_EDIT_GOTO, OnUpdateEditGoto)
	ON_COMMAND(ID_EDIT_OVERVIEW, OnEditOverview)
	ON_UPDATE_COMMAND_UI(ID_EDIT_OVERVIEW, OnUpdateEditOverview)
	ON_COMMAND(ID_EDIT_SELECTALL, OnEditSelectall)
	ON_UPDATE_COMMAND_UI(ID_EDIT_SELECTALL, OnUpdateEditSelectall)
	ON_UPDATE_COMMAND_UI(ID_EDIT_COPY, OnUpdateEditCopy)
	ON_UPDATE_COMMAND_UI(ID_EDIT_CUT, OnUpdateEditCut)
	ON_UPDATE_COMMAND_UI(ID_EDIT_PASTE, OnUpdateEditPaste)
	ON_UPDATE_COMMAND_UI(ID_EDIT_UNDO, OnUpdateEditUndo)
	//}}AFX_MSG_MAP
#ifdef _POCKET
//	ON_WM_CHAR()
//	ON_WM_KEYDOWN()
//	ON_WM_CREATE()
	ON_NOTIFY_REFLECT(GN_CONTEXTMENU, OnContextMenu)
//	ON_WM_DESTROY()
//	ON_WM_SETTINGCHANGE()
//	ON_COMMAND(ID_EDIT_CUT, OnEditCut)
//	ON_COMMAND(ID_EDIT_UNDO, OnEditUndo)
#endif // _WIN32_WCE_PSPC
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CScriptView construction/destruction

//enum UIMetric { UIM_POINT = 1, UIM_PIXEL, UIM_SCALE };

//extern int SHGetUIMetrics( UIMetric metric, int *result, int size, int required );

CScriptView::CScriptView()
{
	// TODO: add construction code here
}

CScriptView::~CScriptView()
{
}

void CScriptView::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{

	switch (nChar)
	{
	case VK_TAB:
		if(GetAsyncKeyState(VK_SHIFT))
			GetEditCtrl().ReplaceSel( TEXT("\t") );
		else
			GetEditCtrl().ReplaceSel( kTabString );
		return;
	case VK_RETURN:
		{
			// Get the number of tabs starting this line, and 
			// start the next line with the same number
			int first,last;
			int iLine;
			int iLength;
			TCHAR sz[256];

			GetEditCtrl().GetSel(first,last);
			iLine=GetEditCtrl().LineFromChar(first);
			iLength=GetEditCtrl().LineLength(first);
			if (iLength > 255)
				break;
			GetEditCtrl().GetLine( iLine, sz, 255 );
			sz[iLength] = '\0';
			
			/*{
				TCHAR szChar[60];
				wsprintf(szChar,L"%i %i %i (%i) '%s'",first,last,iLine,iLength,sz);
				MessageBox(szChar,L"",MB_OK);
			}*/


			CEditView::OnChar(nChar, nRepCnt, nFlags);
			for (int i = 0;  sz[i]==L' ' || sz[i]==L'\t'; i++);
				//do nothing
			//truncate the string - we want only the whitespace at the front..
			sz[i]=0;
			GetEditCtrl().ReplaceSel(sz);
			return;
		}
	default:
		break;
	}
	CEditView::OnChar(nChar, nRepCnt, nFlags);
}

void CScriptView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// just swallow a tab character, so the control does not lose focus
	if (nChar == VK_TAB)
		return;
	else
		CEditView::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CScriptView::OnEditCopy() 
{
	GetEditCtrl().Copy();
}


void CScriptView::OnEditCut() 
{
	GetEditCtrl().Cut();
}

void CScriptView::OnEditPaste() 
{
	GetEditCtrl().Paste();
}

void CScriptView::OnEditUndo() 
{
	GetEditCtrl().Undo();
}

BOOL CScriptView::PreCreateWindow(CREATESTRUCT& cs)
{
	BOOL bPreCreated = CEditView::PreCreateWindow(cs);
	cs.style &= ~(ES_AUTOHSCROLL|WS_HSCROLL);	// Enable word-wrapping
	if(!gbShowEditorWindow)
	{
		cs.style|=ES_READONLY;
		//cs.style&=~WS_VISIBLE;
	}
	cs.dwExStyle |= WS_EX_NOANIMATION;
	return bPreCreated;
}

///////////////////////////////////////////////////////////////////////////////
// CScriptView drawing

void CScriptView::OnDraw(CDC* pDC)
{
	CScriptDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	//pDC->SetBkMode(TRANSPARENT);

	// TODO: add draw code for native data here
}

/////////////////////////////////////////////////////////////////////////////
// CScriptView diagnostics

#undef _DEBUG // EMP DIKEO

#ifdef _DEBUG
void CScriptView::AssertValid() const
{
	CView::AssertValid();
}

void CScriptView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CScriptDoc* CScriptView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CScriptDoc)));
	return (CScriptDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CScriptView message handlers




int CScriptView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
//   lpCreateStruct->style &= ~WS_VISIBLE;
#ifdef _POCKET
	int iResult = CEditView::OnCreate(lpCreateStruct);

	if(iResult == 0)
		ShowDoneButton(TRUE);

	return iResult;
#else
   if (CEditView::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	return 0;
#endif
}

DWORD CScriptView::doCalculateChecksum(const TCHAR *szBuf, DWORD dwSeed)
{

	const TCHAR *szText=szBuf;
	DWORD dwChecksum;

	dwChecksum=dwSeed;//0xf163808f;

	while(*szBuf)
	{
		dwChecksum+=*szBuf;
		dwChecksum=(dwChecksum<<1)+((dwChecksum&0x80000000)>>31);
		szBuf++;
	}

	return dwChecksum;
}

#define ROTATELEFT(x,count) (((x)<<count) | ((x)>>((8*sizeof(x))-count)))
#define ROTATERIGHT(x,count) (((x)>>count) | ((x)<<((8*sizeof(x))-count)))

#define FLIPNIBBLE(x) ( ( (x&0xf0 >> 4) | (x&0x0f<<4) ) )

#define FLIPWORD(x) (    (FLIPNIBBLE((((unsigned short)x)&0xFF00) >> 8 )) | ( (FLIPNIBBLE(((unsigned short)x)&0xFF)) << 8 )   )

#define FLIPLONG(x)	( ( ( FLIPWORD((x&0xFFFF0000) >> 16 ) ) ) | ( (FLIPWORD(x&0xFFFF) << 16 ) ) )

#define kNSBFileFlagV1 0xFF0000DD
#define kNSBFileFlagV2 0xFF0011DD
#define kNSBFileFlagV3 0xFF0022DD

void CScriptView::doWriteEncryptedBytesV2(CArchive& ar, const TCHAR *szBuf, UINT nLen, DWORD dwFileFlag)
{
	int iNumBits=(dwFileFlag==kNSBFileFlagV2)?3:5;
	const TCHAR *pBuf=szBuf;
	while(nLen)
	{
		TCHAR c=ROTATELEFT(*pBuf,iNumBits);
		if(sizeof(TCHAR)==2)
			c=(TCHAR) FLIPWORD(c);
		else
			c=(TCHAR) FLIPNIBBLE(c);
		ar.Write(&c, sizeof(TCHAR));

		pBuf++;
		nLen--;
	}

}

void CScriptView::doWriteASCIIBytes(CArchive& ar, const TCHAR *szBuf, UINT nLen)
{
	const TCHAR *pBuf=szBuf;
	while(nLen)
	{
		char c[2];
		wcstombs(c,pBuf,1);

		ar.Write(&c, sizeof(char));

		pBuf++;
		nLen--;
	}

}


void CScriptView::doDecryptV2(TCHAR *szBuf, UINT nLen, DWORD dwFileFlag)
{
	int iNumBits=(dwFileFlag==kNSBFileFlagV2)?3:5;
	TCHAR *pBuf=szBuf;
	while(nLen)
	{
		if(sizeof(TCHAR)==2)
			*pBuf=(TCHAR) FLIPWORD(*pBuf);
		else
			*pBuf=(TCHAR) FLIPNIBBLE(*pBuf);
		
		*pBuf=ROTATERIGHT(*pBuf,iNumBits);
		*pBuf++;
		nLen--;
	}

}


//DEL void CScriptView::ReadFromArchive(CArchive& ar, UINT nLen)
//DEL 	// Read certain amount of text from the file, assume at least nLen
//DEL 	// characters (not bytes) are in the file.
//DEL {//valid for windows ce only
//DEL 	ASSERT_VALID(this);
//DEL 
//DEL 	LPVOID hText = LocalAlloc(LPTR, (nLen+1)*sizeof(TCHAR));
//DEL 	DWORD dwChecksum, dwFileFlag, dwFileExtra1, dwFileExtra2, dwChecksumSeed;
//DEL 	LPTSTR lpszActualText;
//DEL 	UINT nRealLen=nLen;
//DEL 	UINT nBytesToRead=0;
//DEL 	DWORD dwSerialNumFromFile;
//DEL 
//DEL 	ASSERT(hText);
//DEL 
//DEL 	if (hText == NULL)
//DEL 		AfxThrowMemoryException();
//DEL 
//DEL 	LPTSTR lpszText = (LPTSTR)LocalLock(hText);
//DEL 	ASSERT(lpszText != NULL);
//DEL 
//DEL 	lpszActualText=lpszText;
//DEL 
//DEL 	//pop off our DWORD which is our checksum..
//DEL 	dwChecksum=0;
//DEL 	ar.Read(&dwChecksum,sizeof(DWORD));
//DEL 	dwFileFlag=dwChecksum;
//DEL 	nLen-=(sizeof(DWORD)/sizeof(TCHAR));
//DEL 	if(dwChecksum==kNSBFileFlagV1 || dwChecksum==kNSBFileFlagV2 || dwChecksum==kNSBFileFlagV3)
//DEL 	{
//DEL 		ar.Read(&dwChecksum,sizeof(DWORD));
//DEL 		nLen-=(sizeof(DWORD)/sizeof(TCHAR));
//DEL 	}
//DEL 	else
//DEL 	{//oops!  Not one of my files, so we need to give back the four chars we stole!
//DEL 		memcpy(lpszText,&dwChecksum,sizeof(DWORD));
//DEL 		lpszActualText=(TCHAR *)((char *)lpszActualText+sizeof(DWORD));	
//DEL 		dwChecksum=dwFileFlag=0;
//DEL 	}
//DEL 	if(dwFileFlag==kNSBFileFlagV3)
//DEL 	{//eight more bytes in the header for v3 format!
//DEL 		ar.Read(&dwFileExtra1,sizeof(DWORD));
//DEL 		nLen-=(sizeof(DWORD)/sizeof(TCHAR));
//DEL 		dwSerialNumFromFile=ROTATERIGHT(FLIPLONG(ROTATELEFT((dwFileExtra1),3)),6)^0xF163808F;
//DEL 		ar.Read(&dwFileExtra2,sizeof(DWORD));
//DEL 		nLen-=(sizeof(DWORD)/sizeof(TCHAR));
//DEL 		
//DEL 	}
//DEL 	switch(dwFileFlag)
//DEL 	{
//DEL 	case kNSBFileFlagV3:
//DEL 		gdwPrefFlags|=kPrefSaveProtected; //**JULY99 - for #216
//DEL 		if(gLaunchMode==LM_RUNTIME)
//DEL 		{//runtime mode, we want to check the checksum as calculated from the serial number
//DEL 			//TCHAR szBuf[200];
//DEL 			//wsprintf(szBuf,L"%lu",dwSerialNumFromFile);
//DEL 			dwChecksumSeed=dwSerialNumFromFile;
//DEL 			//::MessageBox(0,L"RUNTIME",szBuf,MB_OK);
//DEL 		}
//DEL 		else //non-runtime, we need this calculation to see if this is "our" file.
//DEL 			dwChecksumSeed=giSerialNumber;
//DEL 		break;
//DEL 	case 0: //plain file..
//DEL 	default:
//DEL 		gdwPrefFlags&=~kPrefSaveProtected; //**JULY99 - for #216
//DEL 		dwChecksumSeed=0xF163808F;
//DEL 		break;
//DEL 	}
//DEL 	doWritePrefsFile();
//DEL 	if(dwFileFlag==0 && dwChecksum==0)
//DEL 	{//this is a "plain" file which means that nRealLen is bogus (because it was
//DEL 		//calculated by taking the number of chars and dividing by two) - this is bad
//DEL 		//for odd numbers.  So, we fix nRealLen by just re-fetching the length of the file.
//DEL 		nRealLen=ar.GetFile()->GetLength(); //number of CHARS, which is also the number of BYTES for ascii
//DEL 
//DEL 		nBytesToRead=nRealLen-sizeof(DWORD); 
//DEL 
//DEL 	}
//DEL 	else
//DEL 		nBytesToRead=nLen*sizeof(TCHAR);
//DEL 
//DEL 	if(nRealLen>2)
//DEL 	{
//DEL 		if ((nBytesToRead - ar.Read(lpszActualText, nBytesToRead) > 2))
//DEL 		{
//DEL 			LocalUnlock(hText);
//DEL 			LocalFree(hText);
//DEL 			AfxThrowArchiveException(CArchiveException::endOfFile);
//DEL 		}
//DEL 	}
//DEL 	// Replace the editing edit buffer with the newly loaded data
//DEL 	
//DEL 	//this line not needed because the buffer starts out full of zeroes..
//DEL 	//lpszText[nRealLen] = '\0';
//DEL 
//DEL 	if(dwFileFlag==kNSBFileFlagV2 || dwFileFlag==kNSBFileFlagV3)
//DEL 	{//encrypted v2 or v3, so de-encrypt it
//DEL 		doDecryptV2(lpszText, nLen, dwFileFlag);
//DEL 	}
//DEL 	else if (dwFileFlag==0 && dwChecksum==0) //plain file
//DEL 	{//plain ascii text.  we need to copy out
//DEL 	 //our ascii and then convert it.
//DEL 		char *pTempBuf;
//DEL 
//DEL 		//nRealLen=ar.GetFile()->GetLength();
//DEL 		pTempBuf=(char *)LocalAlloc(LPTR,nRealLen+1);
//DEL 		if(!pTempBuf)
//DEL 			AfxThrowArchiveException(CArchiveException::generic);
//DEL 		memcpy(pTempBuf,lpszText,nRealLen);
//DEL 		//original buffer isn't big enough because nLen is bogus
//DEL 		LocalFree(hText);
//DEL 		if((hText=(TCHAR *)LocalAlloc(LPTR,(nRealLen+1)*sizeof(TCHAR)) )== 0)
//DEL 		{
//DEL 			LocalFree(pTempBuf);
//DEL 			AfxThrowArchiveException(CArchiveException::generic);
//DEL 		}
//DEL 		lpszText=(TCHAR *)LocalLock(hText);
//DEL 
//DEL 		mbstowcs(lpszText,pTempBuf,nRealLen);
//DEL 		LocalFree(pTempBuf);
//DEL 	}
//DEL 
//DEL 	if(dwFileFlag!=kNSBFileFlagV3 && gbCanOpenPlainFiles) //checksum MUST match for V3 files, regardless of whether this version can open plain files.
//DEL 	{
//DEL 		gbProtectedFile=false;
//DEL 		gbFileHasValidChecksum=true;
//DEL 	}
//DEL 	else 
//DEL 	{
//DEL 		DWORD dwCheck=doCalculateChecksum(lpszText,dwChecksumSeed);
//DEL 		
//DEL 		/*
//DEL 		{
//DEL 			TCHAR szBuf[200];
//DEL 			wsprintf(szBuf,L"%lu dwcheck %lu dwchecksum %lu",dwSerialNumFromFile,dwCheck,dwChecksum);
//DEL 			::MessageBox(0,szBuf,L"",MB_OK);
//DEL 		}
//DEL 		*/
//DEL 
//DEL 		if(dwFileFlag==kNSBFileFlagV3 && dwCheck!=dwChecksum)
//DEL 		{
//DEL 			//gbCloseOnEnd=true;
//DEL 			//gbAllowSave=false;
//DEL 			//gbShowEditorWindow=false;
//DEL 			gbProtectedFile=true;
//DEL 		}
//DEL 		else
//DEL 		{
//DEL 			//SetFlagsForLaunchMode();
//DEL 			gbProtectedFile=false;
//DEL 		}
//DEL 		
//DEL 		if(dwCheck==dwChecksum)
//DEL 		{
//DEL 			gbFileHasValidChecksum=true;
//DEL 		}
//DEL 		
//DEL 	}
//DEL 	if (1)//(afxData.bWinCE)
//DEL 	{
//DEL 		// Set the text with SetWindowText, then free.
//DEL 		// NOTE: Under WinCE, it is necessary to maintain a shadow buffer (since
//DEL 		//       EM_GETHANDLE) doesn't seem to work for the client area.
//DEL 		// NOTE: It is only updated when the control contents have been changed.
//DEL 		BOOL bResult = ::SetWindowText(m_hWnd, lpszText);
//DEL 		int nWindowLen;
//DEL 		int nTextLen;
//DEL 		nTextLen=_tcslen(lpszText);
//DEL 
//DEL 		LocalUnlock(hText);
//DEL 		LocalFree(hText);
//DEL 
//DEL 		nWindowLen=::GetWindowTextLength(m_hWnd);
//DEL 		// make sure that SetWindowText was successful
//DEL 		if (!bResult || nWindowLen < (int)nTextLen)
//DEL 			AfxThrowMemoryException();
//DEL 
//DEL 		// remove old shadow buffer
//DEL 		delete[] m_pShadowBuffer;
//DEL 		m_pShadowBuffer = NULL;
//DEL 		m_nShadowSize = 0;
//DEL 
//DEL 		ASSERT_VALID(this);
//DEL 		return;
//DEL 	}
//DEL 	//vc6fix
//DEL 	/*
//DEL 	LocalUnlock(hText);
//DEL 	HLOCAL hOldText = GetEditCtrl().GetHandle();
//DEL 	ASSERT(hOldText != NULL);
//DEL 	LocalFree(hOldText);
//DEL 	GetEditCtrl().SetHandle((HLOCAL)(UINT)(DWORD)hText);
//DEL 	*/
//DEL 	Invalidate();
//DEL 	ASSERT_VALID(this);
//DEL }

//DEL void CScriptView::WriteToArchive(CArchive& ar)
//DEL {
//DEL 	DWORD dwSeed,dwFileFlag;
//DEL 	ASSERT_VALID(this);
//DEL 	LPCTSTR lpszText = LockBuffer();
//DEL 	ASSERT(lpszText != NULL);
//DEL 	UINT nLen = GetBufferLength();
//DEL 	TRY
//DEL 	{
//DEL 		DWORD dwChecksum;
//DEL 		CString cstrFileName;
//DEL 
//DEL 		cstrFileName=ar.GetFile()->GetFileName();
//DEL 		if(cstrFileName.Right(4).CompareNoCase(TEXT(".txt"))==0)
//DEL 		{
//DEL 			doWriteASCIIBytes(ar,lpszText,nLen);
//DEL 		}
//DEL 		else
//DEL 		{
//DEL 			if(gdwPrefFlags&kPrefSaveProtected)
//DEL 			{
//DEL 				dwFileFlag=kNSBFileFlagV3;
//DEL 				ar.Write(&dwFileFlag, sizeof(DWORD));
//DEL 
//DEL 				dwSeed=giSerialNumber;
//DEL 				dwChecksum=doCalculateChecksum(lpszText,dwSeed);
//DEL 				ar.Write(&dwChecksum, sizeof(DWORD));
//DEL 
//DEL 				dwChecksum=ROTATERIGHT(FLIPLONG(ROTATELEFT((giSerialNumber^0xF163808F),6)),3);
//DEL 
//DEL 				ar.Write(&dwChecksum, sizeof(DWORD));
//DEL 				dwChecksum=0;
//DEL 				ar.Write(&dwChecksum, sizeof(DWORD));
//DEL 			}
//DEL 			else
//DEL 			{
//DEL 				dwFileFlag=kNSBFileFlagV2;
//DEL 				ar.Write(&dwFileFlag, sizeof(DWORD));
//DEL 				dwSeed=0xf163808f;
//DEL 				dwChecksum=doCalculateChecksum(lpszText,dwSeed);
//DEL 				ar.Write(&dwChecksum, sizeof(DWORD));
//DEL 
//DEL 			}
//DEL 
//DEL 
//DEL 			//ar.Write(lpszText, nLen*sizeof(TCHAR));
//DEL 			doWriteEncryptedBytesV2(ar,lpszText,nLen,dwFileFlag);
//DEL 		}
//DEL 	}
//DEL 	CATCH_ALL(e)
//DEL 	{
//DEL 		UnlockBuffer();
//DEL 		THROW_LAST();
//DEL 	}
//DEL 	END_CATCH_ALL
//DEL 	UnlockBuffer();
//DEL 	ASSERT_VALID(this);
//DEL }

//DEL void CScriptView::SerializeRaw(CArchive& ar)
//DEL 	// Read/Write object as stand-alone file.
//DEL {
//DEL 	ASSERT_VALID(this);
//DEL 	if (ar.IsStoring())
//DEL 	{
//DEL 		WriteToArchive(ar);
//DEL 	}
//DEL 	else
//DEL 	{
//DEL 		CFile* pFile = ar.GetFile();
//DEL 		ASSERT(pFile->GetPosition() == 0);
//DEL 		DWORD nFileSize = pFile->GetLength();
//DEL 
//DEL 		gbFileHasValidChecksum=false;
//DEL 
//DEL 		if (nFileSize/sizeof(TCHAR) > nMaxSize)
//DEL 		{
//DEL 			AfxMessageBox(AFX_IDP_FILE_TOO_LARGE);
//DEL 			AfxThrowUserException();
//DEL 		}
//DEL 		// ReadFromArchive takes the number of characters as argument
//DEL 		ReadFromArchive(ar, (UINT)nFileSize/sizeof(TCHAR));
//DEL 	}
//DEL 	ASSERT_VALID(this);
//DEL }

#ifdef _POCKET
void CScriptView::OnContextMenu(NMHDR *pNMHDR, LRESULT *pResult)
{
	NMRGINFO* pnmhdr = reinterpret_cast <NMRGINFO*>(pNMHDR);
	CEdit &edit = GetEditCtrl();

	CMenu menu;
	VERIFY(menu.LoadMenu(IDR_TEXT_SELECTION_CM));

	CMenu* pPopup = menu.GetSubMenu(0);
	ASSERT(pPopup != NULL);
	CWnd* pWndPopupOwner = this;

	while (pWndPopupOwner->GetStyle() & WS_CHILD)
		pWndPopupOwner = pWndPopupOwner->GetParent();

	POINT point = pnmhdr->ptAction;

	pPopup->TrackPopupMenu(TPM_RIGHTALIGN | TPM_TOPALIGN | TPM_NONOTIFY, point.x, point.y,
			pWndPopupOwner);
} // OnContextMenu
#endif

unsigned int iFindLast = 0;
BOOLEAN bCaseSensitive = false;
BOOLEAN bReplaceFlag = false;
TCHAR szFindLast[256] = _T( "" );
TCHAR szReplaceLast[256] = _T( "" );

void CScriptView::doFind( UINT iStartAt, TCHAR *szFind, BOOLEAN bCase, BOOLEAN bReplace )
{
   CFindDialog dlg;
//   CEditView *view=((CEditView*)m_viewList.GetHead());
//   CEdit& doc=view->GetEditCtrl();
   CEdit& doc = GetEditCtrl();
   const TCHAR *szFullText;
   const TCHAR *pFoundAt;
   int iFoundIndex;
   int iFoundLen;
   // 2K Fix - Current Position
   int iCurrentLine = doc.LineFromChar();
   int iSelStart, iSelEnd, iSelLen;
   TCHAR *szReplace;

   doc.GetSel( iSelStart, iSelEnd );
   iSelLen = iSelEnd - iSelStart;
   if( iSelLen <= 0 )
   {
      iSelStart = 0;
      szFullText = LockBuffer();
      iSelEnd = _tcslen( szFullText );
   }

   if( szFind == NULL || _tcslen( szFind ) == 0 )
   {
      iStartAt = 0;
      // Prepare find dialog
      //if( bReplace )
      dlg.m_bShowReplaceUI = true;
      if( iSelLen > 0 )
      {
         if( doc.LineFromChar( iSelStart ) == doc.LineFromChar( iSelEnd ) )
         {
            szFullText = LockBuffer();
            szFullText += iSelStart;
            TCHAR *szBuf = dlg.m_cstrFind.GetBuffer( iSelLen );
            _tcsncpy( szBuf, szFullText, iSelLen );
            dlg.m_cstrFind.ReleaseBuffer( iSelLen );
            UnlockBuffer();
         }
         iStartAt = iSelStart;
      }
      else
         dlg.m_cstrFind = szFindLast;

      // 110600 - MD Added to handle finding in selections
      dlg.m_bFindAll = iSelLen > 0 ? true : false;

      // Open find dialog
      if( dlg.DoModal() != IDOK )
      {
//         doGoto( iCurrentLine );
//         AfxMessageBox( _T( "doGoto #1" ) );
         return;
      }
      // Not searching for anything... exit
      if( dlg.m_cstrFind.IsEmpty() )
         return;

      if( dlg.m_cstrReplace.IsEmpty() )
         bReplace = false; //can't replace with nothing!
      else
         bReplace = true;

      if( !bReplace && dlg.m_bFindAll )
      {//if doing a FIND ALL (not REPLACE ALL), use list display UI.
         CFunctionListDialog dlgList;

         if( dlg.m_cstrFind.IsEmpty() )
         {
//            doGoto( iCurrentLine );
//            AfxMessageBox( _T( "doGoto #2" ) );
            return;
         }

         dlgList.m_bSorted = false;
         dlgList.m_bCaseSensitive = dlg.m_bCaseSensitive;
         dlgList.m_cstrButton = _T( "Go To Line" );
//         dlgList.m_pEditView=((CEditView*)m_viewList.GetHead());
         dlgList.m_pEditView = (CEditView *)this;
         dlgList.m_acstrMatches.Add( dlg.m_cstrFind );

         if( dlgList.DoModal() != IDOK || dlgList.m_iSelectionLine == -1 )
         {
//            doGoto( iCurrentLine );
//            AfxMessageBox( _T( "doGoto #3" ) );
            return;
         }

         // Location picked, go there
         doGoto( dlgList.m_iSelectionLine, false );
//         AfxMessageBox( _T( "doGoto #4" ) );
         // Reset state for next find
         iStartAt = 0;
         szFind = szFindLast;
         _tcscpy( szFind, (LPCTSTR)dlg.m_cstrFind );
         bCase = dlg.m_bCaseSensitive;
         return;
      }
      szFind = szFindLast;
      szReplace = szReplaceLast;
      _tcscpy( szReplace, (LPCTSTR)dlg.m_cstrReplace );
      _tcscpy( szFind, (LPCTSTR)dlg.m_cstrFind );
      bCase = dlg.m_bCaseSensitive;
   }

   szReplace = szReplaceLast;

   iFoundLen = _tcslen( szFind );

//   szFullText=view->LockBuffer();
   szFullText = LockBuffer();
//CString strMessage;
//strMessage.Format( _T( "szFullText Len: %d" ), _tcslen( szFullText ) );
//AfxMessageBox( strMessage );

   if( _tcslen( szFullText ) <= iStartAt )
      iStartAt = 0;
   
   do
   {
      //if we're replacing all, keep looping here..

      int iRepOffset;
      iRepOffset = _tcslen( szReplace ) - _tcslen( szFind );

      szFullText += iStartAt;

      if( bCase )
         pFoundAt = _tcsstr( szFullText, szFind );
      else
         pFoundAt = findSubstringCaseInsensitive( szFullText, szFind );
      iFoundIndex = pFoundAt - szFullText;

      if(    !pFoundAt
          || (    ( iSelLen > 0 )
               && ( iStartAt + (UINT)iFoundIndex > (UINT)iSelEnd ) ) )
      {
         if( !bReplace )
            MessageBeep( MB_ICONQUESTION );
         iFindLast = 0;
//         _tcscpy( szFindLast, _T( "" ) );
         // 2K Fix - Current Position
         int iCurPos = 0;
         if( ( iSelStart = doc.LineIndex( iCurrentLine ) ) != -1 )
            doc.SetSel( iCurPos, iCurPos );
         else
            doc.SetSel( 0, 0 );
         UnlockBuffer();
         return;
      }

      // 110600 - MD Incorporating from fix #207 below
      iFindLast = iStartAt + iFoundIndex + iFoundLen; 
//      iFindLast = iStartAt + iFoundIndex + 1;

      bCaseSensitive = bCase;
      bReplaceFlag = bReplace;
      _tcscpy( szFindLast, szFind );

      UnlockBuffer();
      doc.SetSel( iStartAt + iFoundIndex, iStartAt + iFoundIndex + iFoundLen, false );
      if( bReplace )
      {
         doc.ReplaceSel( szReplace, true );
         // 110600 - MD See "Incorporating" fix above
//         iFindLast+=_tcslen( szReplace );//**JUL99 - fixes #207
                                //old code incremented only by one char, but this
                                //fails when the replacement string contains the
                                //string-to-be-replaced (infinite loop).  Now we
                                //increment by the length of the replacement string
                                //if we are replacing..
         iSelEnd += iRepOffset;
         if( iSelLen > 0 )
            iSelLen += iRepOffset;
         iFindLast += iRepOffset;
      }
//      strMessage.Format( _T( "iSelStart: %d, iSelEnd: %d, iSelLen: %d\niFoundLen: %d\niFoundIndex: %d\niRepOffset: %d\niStartAt: %d, iFindLast: %d" ),
//         iSelStart, iSelEnd, iSelLen, iFoundLen, iFoundIndex, iRepOffset, iStartAt, iFindLast );
//      AfxMessageBox( strMessage );
      iStartAt = iFindLast;
      szFullText = LockBuffer();
      // 110600 - MD Find/Replace selection fix
   } while(    bReplace
            && dlg.m_bFindAll
            && ( iStartAt < (UINT)iSelEnd ) );
//   } while( bReplace && dlg.m_bFindAll && iStartAt < _tcslen( szFullText ) );

   UnlockBuffer();
} // doFind

void CScriptView::doGoto( int iGoto, BOOL bWrappedLines, BOOL bSelLine )
{
   CGotoLineDialog dlg;
//   CEditView *view=((CEditView*)m_viewList.GetHead());
//   CEdit& doc=view->GetEditCtrl();
   CEdit& doc = GetEditCtrl();
   int iEndDoc = doc.GetWindowTextLength();

   if( iGoto == -1 )
   {
      if( ( iGoto = doc.LineFromChar() ) != -1 )
         dlg.m_LineNumber = iGoto;
      if( dlg.DoModal() == IDOK )
         iGoto = dlg.m_LineNumber;
   }
   if( iGoto != -1 )
   {
      int iLine = iGoto;
      int iCharStart, iCharEnd;
      int iReturnCount, iIndex, iBufLen;
      const TCHAR *szBuf;


      if( !bWrappedLines )
      {//go to the nth line in the edit box (as opposed to the nth CR-delimited line in the script)
         iCharStart = doc.LineIndex( iLine );

         if( iCharStart < 0 )
         {
            iCharStart = iCharEnd = iEndDoc;
         }
         else
            iCharEnd = iCharStart + doc.LineLength( iCharStart );
      }
      else
      {//go to the nth CR-delimited line in the script
         szBuf = LockBuffer();
         iBufLen = doc.GetWindowTextLength();

         iReturnCount = iIndex = 0;
         while( iIndex < iBufLen && iReturnCount < iLine )
         {
            if( szBuf[iIndex] == _T( '\r' ) )
               iReturnCount++;
            iIndex++;
         }

         if( iReturnCount == iLine )
         {
            iCharStart = iIndex ? iIndex + 1 : iIndex;
            iCharEnd = iCharStart + doc.LineLength( iCharStart );
         }
         else if( iIndex >= iBufLen )
            iCharStart = iCharEnd = iBufLen;
         else
            iCharStart = iCharEnd = 0;

         UnlockBuffer();
      }
      //first scroll to the end of the doc, then scroll back up - this
      //has the effect of forcing the target line to the top of the window
      doc.SetSel( iEndDoc, iEndDoc );
      if( bSelLine )
         doc.SetSel( iCharStart, iCharEnd );
      else
         doc.SetSel( iCharStart, iCharStart );
   }
} // doGoto

void CScriptView::OnUpdateEditFind(CCmdUI* pCmdUI) 
{
   pCmdUI->Enable( gbShowEditorWindow );
} // OnUpdateEditFind

void CScriptView::OnEditFind() 
{
   doFind( 0, NULL, false, false );
} // OnEditFind

void CScriptView::OnUpdateEditFindall(CCmdUI* pCmdUI) 
{
   pCmdUI->Enable( gbShowEditorWindow );
} // OnUpdateEditFindall

void CScriptView::OnEditFindall() 
{
   CFindDialog dlg;
   CFunctionListDialog dlgList;

   if( dlg.DoModal() != IDOK )
      return;

   if( dlg.m_cstrFind.IsEmpty() )
      return;

   dlgList.m_bSorted = false;
   dlgList.m_bCaseSensitive = dlg.m_bCaseSensitive;
   dlgList.m_cstrButton = _T( "Go To Line" );
//   dlgList.m_pEditView = ( (CEditView*)m_viewList.GetHead() );
   dlgList.m_pEditView = (CEditView*)this;
   dlgList.m_acstrMatches.Add( dlg.m_cstrFind );

   if( dlgList.DoModal() != IDOK || dlgList.m_iSelectionLine == -1 )
      return;

   doGoto( dlgList.m_iSelectionLine, false );
} // OnEditFindall

void CScriptView::OnUpdateEditFindnext(CCmdUI* pCmdUI) 
{
   pCmdUI->Enable( gbShowEditorWindow );
#ifdef _POCKET
   pCmdUI->SetText( bReplaceFlag ? _T( "Replace Next" ) : _T( "Find Next" ) );
#else
   pCmdUI->SetText( bReplaceFlag ? _T( "Replace &Next\tCtrl+G" ) : _T( "Find &Next\tCtrl+G" ) );
#endif
} // OnUpdateEditFindnext

void CScriptView::OnEditFindnext() 
{
	CEdit& doc = GetEditCtrl();
	int iSelStart, iSelEnd;
	doc.GetSel( iSelStart, iSelEnd );
	doc.SetSel( iSelEnd, iSelEnd );

	doFind( iFindLast + iSelEnd - iSelStart, szFindLast, bCaseSensitive, bReplaceFlag );	
} // OnEditFindnext

void CScriptView::OnUpdateEditFormat(CCmdUI* pCmdUI) 
{
   pCmdUI->Enable( gbShowEditorWindow );
} // OnUpdateEditFormat

#define kMaxLineLength 512
void CScriptView::OnEditFormat() 
{
//	CEdit& doc2=((CEditView*)m_viewList.GetHead())->GetEditCtrl();
	CEdit& doc2 = GetEditCtrl();
   // 2K fix
   int iCurrentLine = doc2.LineFromChar();

   CString cstrText;

	RECT rectEdit;
	int iOldRightMargin;

	int iNumLines;
	int iSelStart,iSelEnd;
	int iStartLine, iEndLine;
	int iLineIter;
	int iIndentLevel;
	BOOLEAN bTempIndent=false, bFormattingRange;
	//HCURSOR hcursorOld=SetCursor(LoadCursor(NULL, IDC_WAIT));
	//vc6fix 
	//HCURSOR hcursorOld=SetCursor((HICON)LoadImage(NULL, IDC_WAIT,IMAGE_ICON,0,0,LR_DEFAULTCOLOR));
	SetWaitCursor(true);

	CString cstrCopy;
	CEdit doc;
	int iBodyLen;

	//don't bother if the window has no text in it...
	if((iBodyLen=doc2.GetWindowTextLength())==0)
		return;

	//create an offscreen CEdit so that the screen doesn't update with every change.
	doc2.GetClientRect(&rectEdit);	
	doc.Create(ES_AUTOVSCROLL|ES_AUTOHSCROLL|ES_MULTILINE,rectEdit,doc2.GetParent(),7654);

	//copy the text from the on-screen edit to the off-screen edit
	cstrCopy.Empty();
	doc2.GetWindowText(cstrCopy);
	if(cstrCopy.IsEmpty())
	{//if the string is empty, we probably ran out of memory.
      ::MessageBox( 0, _T( "Unable to format text because there is not enough memory." ), _T( "ERROR" ), MB_OK );
		doc.DestroyWindow();
		return;
	}
	doc.SetWindowText(cstrCopy);
	if(doc.GetWindowTextLength()!=iBodyLen)
	{//if it's not the same length as the original, we probably ran out of memory.
      ::MessageBox( 0, _T( "Unable to format text because there is not enough memory." ), _T( "ERROR" ), MB_OK );
		doc.DestroyWindow();
		return;
	}

	//free the temp string (don't need it any more)
	cstrCopy.Empty();
	
	//default value of rect should be correct, because the window has the same bounds as
	//the on-screen window, so we shouldn't need these calls
	//doc2.GetRect(&rectEdit);
	//doc.SetRect(&rectEdit);


	//get the selection to determine if we are formatting just a portion of the document
	doc2.GetSel(iSelStart,iSelEnd);

	//push out the right margin so there's no word wrapping.
	doc.GetRect(&rectEdit);
	iOldRightMargin=rectEdit.right;
	rectEdit.right=10000;
	doc.SetRect(&rectEdit);
	

	iNumLines=doc.GetLineCount();
	
	iIndentLevel=0;

	iStartLine=doc.LineFromChar(iSelStart);
	iEndLine=doc.LineFromChar(iSelEnd);

	
	if(iSelStart==iSelEnd)
	{//if the start and end lines are the same, then the user probably hasn't selected
	 //a range of text to format, so format the whole body..
		iStartLine=0;
		iEndLine=iNumLines-1;
		bFormattingRange=false;
	}
	else
		bFormattingRange=true;
	
	//walk the lines
	for(iLineIter=iStartLine;iLineIter<=iEndLine;iLineIter++)
	{
		TCHAR szBuf[kMaxLineLength+1];
		TCHAR szInsert[256];
		int iCharIter;
		int iReplaceIter;
		int iCharPos;
		int iIndentIter;
		//int iBackIter;

		iCharPos=doc.LineIndex(iLineIter);

		//DebugStr(L"Line %i begins at %i\n",iLineIter,iCharPos);

		//clear the line buffer (this is necessary, even though we're null-terminating
		//the string, because we might walk off the end a bit when comparing)
		//don't need to do this here, but will later.
		//memset(szBuf,0,sizeof(TCHAR)*kMaxLineLength);

		//get the line and null-terminate it
		szBuf[doc.GetLine(iLineIter,szBuf,kMaxLineLength)]=0;

		//find out where the first interesting (non-whitespace) character is, so we know what
		//part of the string we are replacing with our "new" tab(s)
		iReplaceIter=0;

		while(szBuf[iReplaceIter] && szBuf[iReplaceIter]==(TCHAR)'\t' || szBuf[iReplaceIter]==(TCHAR)' ') 
			iReplaceIter++;
		//if we counted all the way up to a CR or NULL, then there's nothing to strip out
		if(szBuf[iReplaceIter]==(TCHAR)'\r' || szBuf[iReplaceIter]==(TCHAR)'\n' || !szBuf[iReplaceIter]) 
			iReplaceIter=0;

		/*
		while(szBuf[iCharIter] && szBuf[iCharIter]==(TCHAR)'\t' || szBuf[iCharIter]==(TCHAR)' ') 
			iCharIter++;
		
		//if we counted all the way up to a CR or NULL, then there's nothing to strip out
		if(szBuf[iCharIter]==(TCHAR)'\r' || szBuf[iCharIter]==(TCHAR)'\n' || !szBuf[iCharIter]) 
			iCharIter=0;
		//iCharIter is now the number of characters of whitespace that are currently in the line.

		//get rid of trailing whitespace (if any)
		iBackIter=_tcslen(szBuf)-1;
		while(iBackIter>0 and iswspace(szBuf[iBackIter]))
			szBuf[iBackIter--]=0;

		//convert the string to all lower case so we can search for keywords
		_tcslwr(szBuf);

		//DebugStr(L"(indent %i, iCharIter %i)The line is '%s'\n",iIndentLevel, iCharIter, szBuf);
		*/

		//new code for trimming off leading and trailing stuff.
		CString cstrTemp;
		cstrTemp=szBuf;
		cstrTemp=cstrTemp.SpanExcluding(TEXT("'")); //trim off everything after the comment char
		cstrTemp.TrimLeft();
		cstrTemp.TrimRight();
		cstrTemp.MakeLower();


		//memset(szBuf,0,sizeof(TCHAR)*kMaxLineLength);
		_tcscpy(szBuf,(LPCTSTR)cstrTemp);
		//DebugStr(L"%s\n",szBuf);
		
		cstrTemp.Empty();
		//iCharIter is always zero now..iReplaceIter now holds the value which we will use
		//to replace the old tabs with the new
		iCharIter=0;

		//skip this line if it's all whitespace
		if(_tcslen(&szBuf[iCharIter])>0 )
		{
			//figure out if we should out-dent here (don't interpret comments)
			//out-dent if line BEGINS WITH these keywords (note that some have
			//trailing spaces to indicate that another word should follow)
			if( /*(szBuf[iCharIter]!=(TCHAR)'\'') &&*/ //not needed anymore because we've stripped comments off
				(_tcsncmp(szBuf+iCharIter,TEXT("loop"),4)==0 ||
				_tcsncmp(szBuf+iCharIter,TEXT("end "),4)==0 ||
				_tcsncmp(szBuf+iCharIter,TEXT("else"),4)==0 ||
				_tcsncmp(szBuf+iCharIter,TEXT("elseif"),6)==0 ||
				_tcsncmp(szBuf+iCharIter,TEXT("wend"),4)==0 ||
				_tcsncmp(szBuf+iCharIter,TEXT("case "),5)==0  ||
				_tcsncmp(szBuf+iCharIter,TEXT("next "),5)==0  ||
				_tcscmp(szBuf+iCharIter,TEXT("next"))==0  

				//this line is no longer needed, because any trailing whitespace would be obliterated
				//|| _tcsncmp(szBuf+iCharIter,TEXT("next "),4)==0  //this captures a next with a comment (seperated by a space)
				  ))
					iIndentLevel=max(0,iIndentLevel-1);
/*			else if ( _tcslen(szBuf)>=4 &&   //if the line ENDS with next, but NOT "resume next"
				_tcsncmp(szBuf+(_tcslen(szBuf)-4),TEXT("next"),4)==0 &&
				(_tcslen(szBuf)<11 || _tcsncmp(szBuf+(_tcslen(szBuf)-11),TEXT("resume next"),11)!=0) )
					iIndentLevel=max(0,iIndentLevel-1);
*/ 

			
			
			_tcscpy(szInsert,TEXT(""));
			iIndentIter=0;
			while(iIndentIter<iIndentLevel)
			{
				_tcscat(szInsert,kTabString);
				iIndentIter++;
			}
			

			//DebugStr(L"The insert string is '%s'\n",szInsert);
			
			//replace the old with the new

			//DebugStr(L"Set the selection to %i-%i\n",iCharPos,iCharPos+iCharIter);

			//doc.SetSel(iCharPos,iCharPos+iCharIter,true);
			doc.SetSel(iCharPos,iCharPos+iReplaceIter,true);
			doc.ReplaceSel(szInsert,false);

			//now figure out if the next line should be indented
			if( szBuf[_tcslen(szBuf)-1]==(TCHAR)'_' )
			{
				if(!bTempIndent)
					iIndentLevel+=1;
				bTempIndent=true; //temporary one-line indent for the line continuation char..
			}
			else 
			{
				if(bTempIndent)
					iIndentLevel=max(0,iIndentLevel-1); //reverse the temporary one-line indent for the line-continuation char

				bTempIndent=false;
				
				if( //(szBuf[iCharIter]!=(TCHAR)'\'') && //not needed anymore, because we've stripped comments off
				(_tcsncmp(szBuf+iCharIter,TEXT("do "),3)==0 || //do while, do until
				_tcsncmp(szBuf+iCharIter,TEXT("for "),4)==0 ||
				_tcsncmp(szBuf+iCharIter,TEXT("case "),5)==0 ||
				_tcsncmp(szBuf+iCharIter,TEXT("function "),9)==0 ||
				_tcsncmp(szBuf+iCharIter,TEXT("public function "),16)==0 ||
				_tcsncmp(szBuf+iCharIter,TEXT("private function "),17)==0 ||
				//_tcsncmp(szBuf+iCharIter,TEXT("loop"),4)==0 ||
				_tcsncmp(szBuf+iCharIter,TEXT("sub "),4)==0 ||
				_tcsncmp(szBuf+iCharIter,TEXT("public sub "),11)==0 ||
				_tcsncmp(szBuf+iCharIter,TEXT("private sub "),12)==0 ||
				_tcsncmp(szBuf+iCharIter,TEXT("select "),7)==0 ||
				_tcsncmp(szBuf+iCharIter,TEXT("while "),6)==0 ||
				_tcsncmp(szBuf+iCharIter,TEXT("else"),4)==0 ||
				_tcsncmp(szBuf+iCharIter,TEXT("elseif"),6)==0 ||
				//**MARCH99 changed check for 'do alone on a line' to look for do at beginning, not end..
				//_tcsncmp(szBuf+(_tcslen(szBuf)-1)-1,TEXT("do"),2)==0 || //do alone on a line
				(_tcslen(szBuf)==2 && _tcsncmp(szBuf+iCharIter,TEXT("do"),2)==0 )|| //do alone on a line
				(/*_tcsncmp(szBuf+iCharIter,TEXT("if "),3)==0 &&*/ (_tcslen(szBuf)>=5 && _tcsncmp(szBuf+(_tcslen(szBuf)-5),TEXT(" then"),5)==0) ) ) )
					iIndentLevel=min(50,iIndentLevel+1);
			}
		}//if szBuf is not empty

	}//for each line

	
	/* //don't need these any more because we're working in an off-screen window
	rectEdit.right=iOldRightMargin;
	doc.SetRect(&rectEdit);
	doc.SetSel(0,0,false);
	*/

	//copy the text back into the on-screen window
	doc.GetWindowText(cstrCopy);
	//doc2.SetWindowText(cstrCopy);

	//clear the selection (because our changes invalidate the values anyway)
	//doc2.SetSel(0,0,false); 
	
	doc2.SetSel(0,-1,true);
	doc2.ReplaceSel(cstrCopy,true);
   // 2K fix
   if( ( iSelStart = doc2.LineIndex( iCurrentLine ) ) != -1 )
      doc2.SetSel( iSelStart, iSelStart );
   else
      doc2.SetSel( 0, 0 );

	//destroy the offscreen window and free the temp string
	doc.DestroyWindow();
	cstrCopy.Empty();

	//SetCursor(hcursorOld);
	SetWaitCursor(false);
} // OnEditFormat

void CScriptView::OnUpdateEditGoto(CCmdUI* pCmdUI) 
{
   pCmdUI->Enable( gbShowEditorWindow );
} // OnUpdateEditGoto

void CScriptView::OnEditGoto() 
{
	doGoto( -1, true );
} // OnEditGoto

void CScriptView::OnUpdateEditOverview(CCmdUI* pCmdUI) 
{
   pCmdUI->Enable( gbShowEditorWindow );
} // OnUpdateEditOverview

void CScriptView::OnEditOverview() 
{
   CFunctionListDialog dlgList;

   dlgList.m_bSorted = true;
   dlgList.m_bLineBeginningsOnly = true;
   dlgList.m_cstrButton = _T( "Go To Line" );
//   dlgList.m_pEditView = ((CEditView*)m_viewList.GetHead());
   dlgList.m_pEditView = (CEditView *)this;
   dlgList.m_acstrMatches.RemoveAll();
   dlgList.m_acstrMatches.Add( _T( "sub " ) );
   dlgList.m_acstrMatches.Add( _T( "private sub " ) );
   dlgList.m_acstrMatches.Add( _T( "public sub " ) );
   dlgList.m_acstrMatches.Add( _T( "function " ) );
   dlgList.m_acstrMatches.Add( _T( "public function " ) );
   dlgList.m_acstrMatches.Add( _T( "private function " ) );

   if( dlgList.DoModal() != IDOK || dlgList.m_iSelectionLine == -1 )
      return;

   doGoto( dlgList.m_iSelectionLine, false );
} // OnEditOverview

void CScriptView::OnUpdateEditSelectall(CCmdUI* pCmdUI) 
{
   pCmdUI->Enable( gbShowEditorWindow );
} // OnUpdateEditSelectall

void CScriptView::OnEditSelectall() 
{
   CEdit& edit = GetEditCtrl();
   edit.SetSel( 0, -1, true );
} // OnEditSelectall

void CScriptView::OnUpdateEditCopy(CCmdUI* pCmdUI) 
{
   pCmdUI->Enable( gbShowEditorWindow );
} // OnUpdateEditCopy

void CScriptView::OnUpdateEditCut(CCmdUI* pCmdUI) 
{
   pCmdUI->Enable( gbShowEditorWindow );
} // OnUpdateEditCut

void CScriptView::OnUpdateEditPaste(CCmdUI* pCmdUI) 
{
   pCmdUI->Enable( gbShowEditorWindow );
} // OnUpdateEditPaste

void CScriptView::OnUpdateEditUndo(CCmdUI* pCmdUI) 
{
   pCmdUI->Enable( gbShowEditorWindow );
} // OnUpdateEditUndo

void CScriptView::OnInitialUpdate() 
{
	CEditView::OnInitialUpdate();
	CEdit& theEdit = GetEditCtrl();
	theEdit.SetLimitText( 0 );
	if( gbShowEditorWindow )
	{
		CScriptDoc *pDoc = GetDocument();
		SetWindowText( (LPCTSTR)pDoc->m_strCode );
	}
} // OnInitialUpdate

BOOL CScriptView::DestroyWindow() 
{
	// TODO: Add your specialized code here and/or call the base class
//	MessageBox( _T("CScriptView::DestroyWindow()") );	
	return CEditView::DestroyWindow();
}

void CScriptView::OnActivateView(BOOL bActivate, CView* pActivateView, CView* pDeactiveView) 
{
#if _WIN32_WCE >= 420 && defined(_POCKET)
	DWORD result = 0;
	SHGetUIMetrics( SHUIM_FONTSIZE_PIXEL, &result, sizeof(DWORD), 0 );
	CFont *pFont = this->GetFont();
	if( pFont )
	{
		LOGFONT lf;
		pFont->GetLogFont( &lf );
		lf.lfHeight = result + 2;
		lf.lfWidth = 0;
		m_font.CreateFontIndirect( &lf );
		this->SetFont( &m_font, true );
	}
#endif
	CEditView::OnActivateView(bActivate, pActivateView, pDeactiveView);
}
